# Use Reinforcement Learning to Choose Activities for Preparing to Quit Smoking :How Effective a reinforcement learning model is for choosing activities that optimizes the likelihood that users return to the next session and the effort users spend on their activities?

**Author**: Meng Zhang
**Date**: January 2024

This file is for the purpose of guiding any readers to understand and reproduce the analysis for the paper "Use Reinforcement Learning to Choose Activities for Preparing to Quit Smoking: How Effective a reinforcement learning model is for choosing activities that optimizes the likelihood that users return to the next session and the effort users spend on their activities?".

### Disclaimers 
The data this analysis code relied on is part of another study which has not been published by the time I finish my paper. So here I cannot contain the data files.
In addition, this code is heavily adapted from the analysis code of one of my supervisor's papers, titled "Persuading to Prepare for Quitting Smoking with a Virtual Coach: Using States and User Characteristics to Predict Behavior" and the code is publicly available in 4TU.ResarchData with doi https://doi.org/10.4121/22153898.v1. 
The major difference is the reward function, since here I need to use the weighted sum of two goals and there are also some subsequent adaptions because of this. 

### Explanation of the Data used
Since I cannot include the original data set here. I will explain the part of the data that I used.
- prolific_profile_anonym.csv which has five fields:
  - rand_id: random id generated to represent participants.
  - Completion code: Completion code from prescreening questionnaire on Prolific. CJ8QWQ2B means that the person was eligible for the next study part. C8YZ2HEL means that the person was not contemplating or preparing to quit smoking.
  - Gender: responses can be man, woman or non-binary.
  - Highest education level completed: responses can be "No formal qualifications", "Secondary education (e.g. GED/GCSE)", "High school diploma/A-levels", "Technical/community college",
"Undergraduate degree (BA/BSc/other)", "Graduate degree (MA/MSc/MPhil/other)", "Doctorate degree (PhD/other)", "Don't know / not applicable".
  - Age: calculated based on the date of birth.
- sessiondata_anonym.cse, which has four fields:
  - rand_id: random id generated to represent participants.
  - session_num: represents which session the data is from, ranging from 1 to 5.
  - response_type: state_1 to state_9, state_busy, state_engergy, activity_new_index, 
cluster_new_index, dropout_response, mood, activity_experience_slot, activity_experience_mod_slot.
  - response_value: 
    - state_1 to state_9 denote the usefulness beliefs, rated on scales from -10 to 10. 
    - state_busy is rated on a scale from -5 to 5, 
    - state_energy is rated on a scale from 0 to 10, 
    - activity_new_index is the index of the activity assigned in the session ranging from 0 to 52. 
    - cluster_new_index is the cluster index of the activity assigned in the session ranging from 1 to 14. 
    - effort is based on the question "Please rate the overall effort you put into doing this activity",rated on a scale from 0 to 10. 
    - dropout_response is to rate how likely they would like to return to next session, rated on a scale from -5("definitely would have quit the program") to 5("definitely would have returned to this session").
  
### Explanation of Files and Folders

This directory contains the following files and folders:
- Figures: contains all the figures we created for the paper.
- analysis_q1.py: contains the code for analytical question Q1 and Figure 2.
- analysis-q2.py: contains the code for analytical question Q2 and Figure 3.
- analysis-q3.py: contains the code for analytical question Q3 and Figure 4 and Figure 5.
- analysis-q4.py: contains the code for analytical question Q4 and Figure 6
- analysis-q5_1.py: contains the code for analytical question Q5 (the first case) and Figure 7 and Figure 9.
- analysis-q5_1.py: contains the code for analytical question Q5 (the second case) and Figure 8 and Figure 10.
- Calculate_Actions.py: contains the code for computing the mean reward per action.
- Calculate_Q_values.py: contains the code for computing Q-values and the dynamics of the MDP.
- prolific.py: contains the code for obtaining the characteristics of the data.
- correlation_test.py: contains the code for calculating the correlation between two goals.
- data_preprocessiong.py: code for preprocess the raw data
- Utils.py: contains some common functions for calculating for the reinforcement learning model.
- README.md: This README-file.


